// Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Zig --internal-static --public-function-case camelCase --private-function-case camelCase --public-type-case UpperCamelCase --private-type-case UpperCamelCase --no-prefix-fiat --package-name p256 '' 64 '2^256 - 2^224 + 2^192 + 2^96 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
// curve description (via package name): p256
// machine_wordsize = 64 (from "64")
// requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
// m = 0xffffffff00000001000000000000000000000000ffffffffffffffffffffffff (from "2^256 - 2^224 + 2^192 + 2^96 - 1")
//
// NOTE: In addition to the bounds specified above each function, all
//   functions synthesized for this Montgomery arithmetic require the
//   input to be strictly less than the prime modulus (m), and also
//   require the input to be in the unique saturated representation.
//   All functions also ensure that these two properties are true of
//   return values.
//
// Computed values:
//   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

const std = @import("std");
const mode = @import("builtin").mode; // Checked arithmetic is disabled in non-debug modes to avoid side channels

// The type MontgomeryDomainFieldElement is a field element in the Montgomery domain.
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub const MontgomeryDomainFieldElement = [4]u64;

// The type NonMontgomeryDomainFieldElement is a field element NOT in the Montgomery domain.
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub const NonMontgomeryDomainFieldElement = [4]u64;

/// The function addcarryxU64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
inline fn addcarryxU64(out1: *u64, out2: *u1, arg1: u1, arg2: u64, arg3: u64) void {
    @setRuntimeSafety(mode == .Debug);

    var t: u64 = undefined;
    const carry1 = @addWithOverflow(u64, arg2, arg3, &t);
    const carry2 = @addWithOverflow(u64, t, arg1, out1);
    out2.* = @boolToInt(carry1) | @boolToInt(carry2);
}

/// The function subborrowxU64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
inline fn subborrowxU64(out1: *u64, out2: *u1, arg1: u1, arg2: u64, arg3: u64) void {
    @setRuntimeSafety(mode == .Debug);

    var t: u64 = undefined;
    const carry1 = @subWithOverflow(u64, arg2, arg3, &t);
    const carry2 = @subWithOverflow(u64, t, arg1, out1);
    out2.* = @boolToInt(carry1) | @boolToInt(carry2);
}

/// The function mulxU64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
inline fn mulxU64(out1: *u64, out2: *u64, arg1: u64, arg2: u64) void {
    @setRuntimeSafety(mode == .Debug);

    const x = @as(u128, arg1) * @as(u128, arg2);
    out1.* = @truncate(u64, x);
    out2.* = @truncate(u64, x >> 64);
}

/// The function cmovznzU64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
inline fn cmovznzU64(out1: *u64, arg1: u1, arg2: u64, arg3: u64) void {
    @setRuntimeSafety(mode == .Debug);

    const mask = 0 -% @as(u64, arg1);
    out1.* = (mask & arg3) | ((~mask) & arg2);
}

/// The function mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
pub fn mul(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement, arg2: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[1]);
    const x2 = (arg1[2]);
    const x3 = (arg1[3]);
    const x4 = (arg1[0]);
    var x5: u64 = undefined;
    var x6: u64 = undefined;
    mulxU64(&x5, &x6, x4, (arg2[3]));
    var x7: u64 = undefined;
    var x8: u64 = undefined;
    mulxU64(&x7, &x8, x4, (arg2[2]));
    var x9: u64 = undefined;
    var x10: u64 = undefined;
    mulxU64(&x9, &x10, x4, (arg2[1]));
    var x11: u64 = undefined;
    var x12: u64 = undefined;
    mulxU64(&x11, &x12, x4, (arg2[0]));
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    addcarryxU64(&x13, &x14, 0x0, x12, x9);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    addcarryxU64(&x15, &x16, x14, x10, x7);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    addcarryxU64(&x17, &x18, x16, x8, x5);
    const x19 = (@as(u64, x18) + x6);
    var x20: u64 = undefined;
    var x21: u64 = undefined;
    mulxU64(&x20, &x21, x11, 0xffffffff00000001);
    var x22: u64 = undefined;
    var x23: u64 = undefined;
    mulxU64(&x22, &x23, x11, 0xffffffff);
    var x24: u64 = undefined;
    var x25: u64 = undefined;
    mulxU64(&x24, &x25, x11, 0xffffffffffffffff);
    var x26: u64 = undefined;
    var x27: u1 = undefined;
    addcarryxU64(&x26, &x27, 0x0, x25, x22);
    const x28 = (@as(u64, x27) + x23);
    var x29: u64 = undefined;
    var x30: u1 = undefined;
    addcarryxU64(&x29, &x30, 0x0, x11, x24);
    var x31: u64 = undefined;
    var x32: u1 = undefined;
    addcarryxU64(&x31, &x32, x30, x13, x26);
    var x33: u64 = undefined;
    var x34: u1 = undefined;
    addcarryxU64(&x33, &x34, x32, x15, x28);
    var x35: u64 = undefined;
    var x36: u1 = undefined;
    addcarryxU64(&x35, &x36, x34, x17, x20);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, x36, x19, x21);
    var x39: u64 = undefined;
    var x40: u64 = undefined;
    mulxU64(&x39, &x40, x1, (arg2[3]));
    var x41: u64 = undefined;
    var x42: u64 = undefined;
    mulxU64(&x41, &x42, x1, (arg2[2]));
    var x43: u64 = undefined;
    var x44: u64 = undefined;
    mulxU64(&x43, &x44, x1, (arg2[1]));
    var x45: u64 = undefined;
    var x46: u64 = undefined;
    mulxU64(&x45, &x46, x1, (arg2[0]));
    var x47: u64 = undefined;
    var x48: u1 = undefined;
    addcarryxU64(&x47, &x48, 0x0, x46, x43);
    var x49: u64 = undefined;
    var x50: u1 = undefined;
    addcarryxU64(&x49, &x50, x48, x44, x41);
    var x51: u64 = undefined;
    var x52: u1 = undefined;
    addcarryxU64(&x51, &x52, x50, x42, x39);
    const x53 = (@as(u64, x52) + x40);
    var x54: u64 = undefined;
    var x55: u1 = undefined;
    addcarryxU64(&x54, &x55, 0x0, x31, x45);
    var x56: u64 = undefined;
    var x57: u1 = undefined;
    addcarryxU64(&x56, &x57, x55, x33, x47);
    var x58: u64 = undefined;
    var x59: u1 = undefined;
    addcarryxU64(&x58, &x59, x57, x35, x49);
    var x60: u64 = undefined;
    var x61: u1 = undefined;
    addcarryxU64(&x60, &x61, x59, x37, x51);
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, x61, @as(u64, x38), x53);
    var x64: u64 = undefined;
    var x65: u64 = undefined;
    mulxU64(&x64, &x65, x54, 0xffffffff00000001);
    var x66: u64 = undefined;
    var x67: u64 = undefined;
    mulxU64(&x66, &x67, x54, 0xffffffff);
    var x68: u64 = undefined;
    var x69: u64 = undefined;
    mulxU64(&x68, &x69, x54, 0xffffffffffffffff);
    var x70: u64 = undefined;
    var x71: u1 = undefined;
    addcarryxU64(&x70, &x71, 0x0, x69, x66);
    const x72 = (@as(u64, x71) + x67);
    var x73: u64 = undefined;
    var x74: u1 = undefined;
    addcarryxU64(&x73, &x74, 0x0, x54, x68);
    var x75: u64 = undefined;
    var x76: u1 = undefined;
    addcarryxU64(&x75, &x76, x74, x56, x70);
    var x77: u64 = undefined;
    var x78: u1 = undefined;
    addcarryxU64(&x77, &x78, x76, x58, x72);
    var x79: u64 = undefined;
    var x80: u1 = undefined;
    addcarryxU64(&x79, &x80, x78, x60, x64);
    var x81: u64 = undefined;
    var x82: u1 = undefined;
    addcarryxU64(&x81, &x82, x80, x62, x65);
    const x83 = (@as(u64, x82) + @as(u64, x63));
    var x84: u64 = undefined;
    var x85: u64 = undefined;
    mulxU64(&x84, &x85, x2, (arg2[3]));
    var x86: u64 = undefined;
    var x87: u64 = undefined;
    mulxU64(&x86, &x87, x2, (arg2[2]));
    var x88: u64 = undefined;
    var x89: u64 = undefined;
    mulxU64(&x88, &x89, x2, (arg2[1]));
    var x90: u64 = undefined;
    var x91: u64 = undefined;
    mulxU64(&x90, &x91, x2, (arg2[0]));
    var x92: u64 = undefined;
    var x93: u1 = undefined;
    addcarryxU64(&x92, &x93, 0x0, x91, x88);
    var x94: u64 = undefined;
    var x95: u1 = undefined;
    addcarryxU64(&x94, &x95, x93, x89, x86);
    var x96: u64 = undefined;
    var x97: u1 = undefined;
    addcarryxU64(&x96, &x97, x95, x87, x84);
    const x98 = (@as(u64, x97) + x85);
    var x99: u64 = undefined;
    var x100: u1 = undefined;
    addcarryxU64(&x99, &x100, 0x0, x75, x90);
    var x101: u64 = undefined;
    var x102: u1 = undefined;
    addcarryxU64(&x101, &x102, x100, x77, x92);
    var x103: u64 = undefined;
    var x104: u1 = undefined;
    addcarryxU64(&x103, &x104, x102, x79, x94);
    var x105: u64 = undefined;
    var x106: u1 = undefined;
    addcarryxU64(&x105, &x106, x104, x81, x96);
    var x107: u64 = undefined;
    var x108: u1 = undefined;
    addcarryxU64(&x107, &x108, x106, x83, x98);
    var x109: u64 = undefined;
    var x110: u64 = undefined;
    mulxU64(&x109, &x110, x99, 0xffffffff00000001);
    var x111: u64 = undefined;
    var x112: u64 = undefined;
    mulxU64(&x111, &x112, x99, 0xffffffff);
    var x113: u64 = undefined;
    var x114: u64 = undefined;
    mulxU64(&x113, &x114, x99, 0xffffffffffffffff);
    var x115: u64 = undefined;
    var x116: u1 = undefined;
    addcarryxU64(&x115, &x116, 0x0, x114, x111);
    const x117 = (@as(u64, x116) + x112);
    var x118: u64 = undefined;
    var x119: u1 = undefined;
    addcarryxU64(&x118, &x119, 0x0, x99, x113);
    var x120: u64 = undefined;
    var x121: u1 = undefined;
    addcarryxU64(&x120, &x121, x119, x101, x115);
    var x122: u64 = undefined;
    var x123: u1 = undefined;
    addcarryxU64(&x122, &x123, x121, x103, x117);
    var x124: u64 = undefined;
    var x125: u1 = undefined;
    addcarryxU64(&x124, &x125, x123, x105, x109);
    var x126: u64 = undefined;
    var x127: u1 = undefined;
    addcarryxU64(&x126, &x127, x125, x107, x110);
    const x128 = (@as(u64, x127) + @as(u64, x108));
    var x129: u64 = undefined;
    var x130: u64 = undefined;
    mulxU64(&x129, &x130, x3, (arg2[3]));
    var x131: u64 = undefined;
    var x132: u64 = undefined;
    mulxU64(&x131, &x132, x3, (arg2[2]));
    var x133: u64 = undefined;
    var x134: u64 = undefined;
    mulxU64(&x133, &x134, x3, (arg2[1]));
    var x135: u64 = undefined;
    var x136: u64 = undefined;
    mulxU64(&x135, &x136, x3, (arg2[0]));
    var x137: u64 = undefined;
    var x138: u1 = undefined;
    addcarryxU64(&x137, &x138, 0x0, x136, x133);
    var x139: u64 = undefined;
    var x140: u1 = undefined;
    addcarryxU64(&x139, &x140, x138, x134, x131);
    var x141: u64 = undefined;
    var x142: u1 = undefined;
    addcarryxU64(&x141, &x142, x140, x132, x129);
    const x143 = (@as(u64, x142) + x130);
    var x144: u64 = undefined;
    var x145: u1 = undefined;
    addcarryxU64(&x144, &x145, 0x0, x120, x135);
    var x146: u64 = undefined;
    var x147: u1 = undefined;
    addcarryxU64(&x146, &x147, x145, x122, x137);
    var x148: u64 = undefined;
    var x149: u1 = undefined;
    addcarryxU64(&x148, &x149, x147, x124, x139);
    var x150: u64 = undefined;
    var x151: u1 = undefined;
    addcarryxU64(&x150, &x151, x149, x126, x141);
    var x152: u64 = undefined;
    var x153: u1 = undefined;
    addcarryxU64(&x152, &x153, x151, x128, x143);
    var x154: u64 = undefined;
    var x155: u64 = undefined;
    mulxU64(&x154, &x155, x144, 0xffffffff00000001);
    var x156: u64 = undefined;
    var x157: u64 = undefined;
    mulxU64(&x156, &x157, x144, 0xffffffff);
    var x158: u64 = undefined;
    var x159: u64 = undefined;
    mulxU64(&x158, &x159, x144, 0xffffffffffffffff);
    var x160: u64 = undefined;
    var x161: u1 = undefined;
    addcarryxU64(&x160, &x161, 0x0, x159, x156);
    const x162 = (@as(u64, x161) + x157);
    var x163: u64 = undefined;
    var x164: u1 = undefined;
    addcarryxU64(&x163, &x164, 0x0, x144, x158);
    var x165: u64 = undefined;
    var x166: u1 = undefined;
    addcarryxU64(&x165, &x166, x164, x146, x160);
    var x167: u64 = undefined;
    var x168: u1 = undefined;
    addcarryxU64(&x167, &x168, x166, x148, x162);
    var x169: u64 = undefined;
    var x170: u1 = undefined;
    addcarryxU64(&x169, &x170, x168, x150, x154);
    var x171: u64 = undefined;
    var x172: u1 = undefined;
    addcarryxU64(&x171, &x172, x170, x152, x155);
    const x173 = (@as(u64, x172) + @as(u64, x153));
    var x174: u64 = undefined;
    var x175: u1 = undefined;
    subborrowxU64(&x174, &x175, 0x0, x165, 0xffffffffffffffff);
    var x176: u64 = undefined;
    var x177: u1 = undefined;
    subborrowxU64(&x176, &x177, x175, x167, 0xffffffff);
    var x178: u64 = undefined;
    var x179: u1 = undefined;
    subborrowxU64(&x178, &x179, x177, x169, @as(u64, 0x0));
    var x180: u64 = undefined;
    var x181: u1 = undefined;
    subborrowxU64(&x180, &x181, x179, x171, 0xffffffff00000001);
    var x182: u64 = undefined;
    var x183: u1 = undefined;
    subborrowxU64(&x182, &x183, x181, x173, @as(u64, 0x0));
    var x184: u64 = undefined;
    cmovznzU64(&x184, x183, x174, x165);
    var x185: u64 = undefined;
    cmovznzU64(&x185, x183, x176, x167);
    var x186: u64 = undefined;
    cmovznzU64(&x186, x183, x178, x169);
    var x187: u64 = undefined;
    cmovznzU64(&x187, x183, x180, x171);
    out1[0] = x184;
    out1[1] = x185;
    out1[2] = x186;
    out1[3] = x187;
}

/// The function square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
pub fn square(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[1]);
    const x2 = (arg1[2]);
    const x3 = (arg1[3]);
    const x4 = (arg1[0]);
    var x5: u64 = undefined;
    var x6: u64 = undefined;
    mulxU64(&x5, &x6, x4, (arg1[3]));
    var x7: u64 = undefined;
    var x8: u64 = undefined;
    mulxU64(&x7, &x8, x4, (arg1[2]));
    var x9: u64 = undefined;
    var x10: u64 = undefined;
    mulxU64(&x9, &x10, x4, (arg1[1]));
    var x11: u64 = undefined;
    var x12: u64 = undefined;
    mulxU64(&x11, &x12, x4, (arg1[0]));
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    addcarryxU64(&x13, &x14, 0x0, x12, x9);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    addcarryxU64(&x15, &x16, x14, x10, x7);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    addcarryxU64(&x17, &x18, x16, x8, x5);
    const x19 = (@as(u64, x18) + x6);
    var x20: u64 = undefined;
    var x21: u64 = undefined;
    mulxU64(&x20, &x21, x11, 0xffffffff00000001);
    var x22: u64 = undefined;
    var x23: u64 = undefined;
    mulxU64(&x22, &x23, x11, 0xffffffff);
    var x24: u64 = undefined;
    var x25: u64 = undefined;
    mulxU64(&x24, &x25, x11, 0xffffffffffffffff);
    var x26: u64 = undefined;
    var x27: u1 = undefined;
    addcarryxU64(&x26, &x27, 0x0, x25, x22);
    const x28 = (@as(u64, x27) + x23);
    var x29: u64 = undefined;
    var x30: u1 = undefined;
    addcarryxU64(&x29, &x30, 0x0, x11, x24);
    var x31: u64 = undefined;
    var x32: u1 = undefined;
    addcarryxU64(&x31, &x32, x30, x13, x26);
    var x33: u64 = undefined;
    var x34: u1 = undefined;
    addcarryxU64(&x33, &x34, x32, x15, x28);
    var x35: u64 = undefined;
    var x36: u1 = undefined;
    addcarryxU64(&x35, &x36, x34, x17, x20);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, x36, x19, x21);
    var x39: u64 = undefined;
    var x40: u64 = undefined;
    mulxU64(&x39, &x40, x1, (arg1[3]));
    var x41: u64 = undefined;
    var x42: u64 = undefined;
    mulxU64(&x41, &x42, x1, (arg1[2]));
    var x43: u64 = undefined;
    var x44: u64 = undefined;
    mulxU64(&x43, &x44, x1, (arg1[1]));
    var x45: u64 = undefined;
    var x46: u64 = undefined;
    mulxU64(&x45, &x46, x1, (arg1[0]));
    var x47: u64 = undefined;
    var x48: u1 = undefined;
    addcarryxU64(&x47, &x48, 0x0, x46, x43);
    var x49: u64 = undefined;
    var x50: u1 = undefined;
    addcarryxU64(&x49, &x50, x48, x44, x41);
    var x51: u64 = undefined;
    var x52: u1 = undefined;
    addcarryxU64(&x51, &x52, x50, x42, x39);
    const x53 = (@as(u64, x52) + x40);
    var x54: u64 = undefined;
    var x55: u1 = undefined;
    addcarryxU64(&x54, &x55, 0x0, x31, x45);
    var x56: u64 = undefined;
    var x57: u1 = undefined;
    addcarryxU64(&x56, &x57, x55, x33, x47);
    var x58: u64 = undefined;
    var x59: u1 = undefined;
    addcarryxU64(&x58, &x59, x57, x35, x49);
    var x60: u64 = undefined;
    var x61: u1 = undefined;
    addcarryxU64(&x60, &x61, x59, x37, x51);
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, x61, @as(u64, x38), x53);
    var x64: u64 = undefined;
    var x65: u64 = undefined;
    mulxU64(&x64, &x65, x54, 0xffffffff00000001);
    var x66: u64 = undefined;
    var x67: u64 = undefined;
    mulxU64(&x66, &x67, x54, 0xffffffff);
    var x68: u64 = undefined;
    var x69: u64 = undefined;
    mulxU64(&x68, &x69, x54, 0xffffffffffffffff);
    var x70: u64 = undefined;
    var x71: u1 = undefined;
    addcarryxU64(&x70, &x71, 0x0, x69, x66);
    const x72 = (@as(u64, x71) + x67);
    var x73: u64 = undefined;
    var x74: u1 = undefined;
    addcarryxU64(&x73, &x74, 0x0, x54, x68);
    var x75: u64 = undefined;
    var x76: u1 = undefined;
    addcarryxU64(&x75, &x76, x74, x56, x70);
    var x77: u64 = undefined;
    var x78: u1 = undefined;
    addcarryxU64(&x77, &x78, x76, x58, x72);
    var x79: u64 = undefined;
    var x80: u1 = undefined;
    addcarryxU64(&x79, &x80, x78, x60, x64);
    var x81: u64 = undefined;
    var x82: u1 = undefined;
    addcarryxU64(&x81, &x82, x80, x62, x65);
    const x83 = (@as(u64, x82) + @as(u64, x63));
    var x84: u64 = undefined;
    var x85: u64 = undefined;
    mulxU64(&x84, &x85, x2, (arg1[3]));
    var x86: u64 = undefined;
    var x87: u64 = undefined;
    mulxU64(&x86, &x87, x2, (arg1[2]));
    var x88: u64 = undefined;
    var x89: u64 = undefined;
    mulxU64(&x88, &x89, x2, (arg1[1]));
    var x90: u64 = undefined;
    var x91: u64 = undefined;
    mulxU64(&x90, &x91, x2, (arg1[0]));
    var x92: u64 = undefined;
    var x93: u1 = undefined;
    addcarryxU64(&x92, &x93, 0x0, x91, x88);
    var x94: u64 = undefined;
    var x95: u1 = undefined;
    addcarryxU64(&x94, &x95, x93, x89, x86);
    var x96: u64 = undefined;
    var x97: u1 = undefined;
    addcarryxU64(&x96, &x97, x95, x87, x84);
    const x98 = (@as(u64, x97) + x85);
    var x99: u64 = undefined;
    var x100: u1 = undefined;
    addcarryxU64(&x99, &x100, 0x0, x75, x90);
    var x101: u64 = undefined;
    var x102: u1 = undefined;
    addcarryxU64(&x101, &x102, x100, x77, x92);
    var x103: u64 = undefined;
    var x104: u1 = undefined;
    addcarryxU64(&x103, &x104, x102, x79, x94);
    var x105: u64 = undefined;
    var x106: u1 = undefined;
    addcarryxU64(&x105, &x106, x104, x81, x96);
    var x107: u64 = undefined;
    var x108: u1 = undefined;
    addcarryxU64(&x107, &x108, x106, x83, x98);
    var x109: u64 = undefined;
    var x110: u64 = undefined;
    mulxU64(&x109, &x110, x99, 0xffffffff00000001);
    var x111: u64 = undefined;
    var x112: u64 = undefined;
    mulxU64(&x111, &x112, x99, 0xffffffff);
    var x113: u64 = undefined;
    var x114: u64 = undefined;
    mulxU64(&x113, &x114, x99, 0xffffffffffffffff);
    var x115: u64 = undefined;
    var x116: u1 = undefined;
    addcarryxU64(&x115, &x116, 0x0, x114, x111);
    const x117 = (@as(u64, x116) + x112);
    var x118: u64 = undefined;
    var x119: u1 = undefined;
    addcarryxU64(&x118, &x119, 0x0, x99, x113);
    var x120: u64 = undefined;
    var x121: u1 = undefined;
    addcarryxU64(&x120, &x121, x119, x101, x115);
    var x122: u64 = undefined;
    var x123: u1 = undefined;
    addcarryxU64(&x122, &x123, x121, x103, x117);
    var x124: u64 = undefined;
    var x125: u1 = undefined;
    addcarryxU64(&x124, &x125, x123, x105, x109);
    var x126: u64 = undefined;
    var x127: u1 = undefined;
    addcarryxU64(&x126, &x127, x125, x107, x110);
    const x128 = (@as(u64, x127) + @as(u64, x108));
    var x129: u64 = undefined;
    var x130: u64 = undefined;
    mulxU64(&x129, &x130, x3, (arg1[3]));
    var x131: u64 = undefined;
    var x132: u64 = undefined;
    mulxU64(&x131, &x132, x3, (arg1[2]));
    var x133: u64 = undefined;
    var x134: u64 = undefined;
    mulxU64(&x133, &x134, x3, (arg1[1]));
    var x135: u64 = undefined;
    var x136: u64 = undefined;
    mulxU64(&x135, &x136, x3, (arg1[0]));
    var x137: u64 = undefined;
    var x138: u1 = undefined;
    addcarryxU64(&x137, &x138, 0x0, x136, x133);
    var x139: u64 = undefined;
    var x140: u1 = undefined;
    addcarryxU64(&x139, &x140, x138, x134, x131);
    var x141: u64 = undefined;
    var x142: u1 = undefined;
    addcarryxU64(&x141, &x142, x140, x132, x129);
    const x143 = (@as(u64, x142) + x130);
    var x144: u64 = undefined;
    var x145: u1 = undefined;
    addcarryxU64(&x144, &x145, 0x0, x120, x135);
    var x146: u64 = undefined;
    var x147: u1 = undefined;
    addcarryxU64(&x146, &x147, x145, x122, x137);
    var x148: u64 = undefined;
    var x149: u1 = undefined;
    addcarryxU64(&x148, &x149, x147, x124, x139);
    var x150: u64 = undefined;
    var x151: u1 = undefined;
    addcarryxU64(&x150, &x151, x149, x126, x141);
    var x152: u64 = undefined;
    var x153: u1 = undefined;
    addcarryxU64(&x152, &x153, x151, x128, x143);
    var x154: u64 = undefined;
    var x155: u64 = undefined;
    mulxU64(&x154, &x155, x144, 0xffffffff00000001);
    var x156: u64 = undefined;
    var x157: u64 = undefined;
    mulxU64(&x156, &x157, x144, 0xffffffff);
    var x158: u64 = undefined;
    var x159: u64 = undefined;
    mulxU64(&x158, &x159, x144, 0xffffffffffffffff);
    var x160: u64 = undefined;
    var x161: u1 = undefined;
    addcarryxU64(&x160, &x161, 0x0, x159, x156);
    const x162 = (@as(u64, x161) + x157);
    var x163: u64 = undefined;
    var x164: u1 = undefined;
    addcarryxU64(&x163, &x164, 0x0, x144, x158);
    var x165: u64 = undefined;
    var x166: u1 = undefined;
    addcarryxU64(&x165, &x166, x164, x146, x160);
    var x167: u64 = undefined;
    var x168: u1 = undefined;
    addcarryxU64(&x167, &x168, x166, x148, x162);
    var x169: u64 = undefined;
    var x170: u1 = undefined;
    addcarryxU64(&x169, &x170, x168, x150, x154);
    var x171: u64 = undefined;
    var x172: u1 = undefined;
    addcarryxU64(&x171, &x172, x170, x152, x155);
    const x173 = (@as(u64, x172) + @as(u64, x153));
    var x174: u64 = undefined;
    var x175: u1 = undefined;
    subborrowxU64(&x174, &x175, 0x0, x165, 0xffffffffffffffff);
    var x176: u64 = undefined;
    var x177: u1 = undefined;
    subborrowxU64(&x176, &x177, x175, x167, 0xffffffff);
    var x178: u64 = undefined;
    var x179: u1 = undefined;
    subborrowxU64(&x178, &x179, x177, x169, @as(u64, 0x0));
    var x180: u64 = undefined;
    var x181: u1 = undefined;
    subborrowxU64(&x180, &x181, x179, x171, 0xffffffff00000001);
    var x182: u64 = undefined;
    var x183: u1 = undefined;
    subborrowxU64(&x182, &x183, x181, x173, @as(u64, 0x0));
    var x184: u64 = undefined;
    cmovznzU64(&x184, x183, x174, x165);
    var x185: u64 = undefined;
    cmovznzU64(&x185, x183, x176, x167);
    var x186: u64 = undefined;
    cmovznzU64(&x186, x183, x178, x169);
    var x187: u64 = undefined;
    cmovznzU64(&x187, x183, x180, x171);
    out1[0] = x184;
    out1[1] = x185;
    out1[2] = x186;
    out1[3] = x187;
}

/// The function add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
pub fn add(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement, arg2: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    addcarryxU64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    var x3: u64 = undefined;
    var x4: u1 = undefined;
    addcarryxU64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    var x5: u64 = undefined;
    var x6: u1 = undefined;
    addcarryxU64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    var x7: u64 = undefined;
    var x8: u1 = undefined;
    addcarryxU64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    var x9: u64 = undefined;
    var x10: u1 = undefined;
    subborrowxU64(&x9, &x10, 0x0, x1, 0xffffffffffffffff);
    var x11: u64 = undefined;
    var x12: u1 = undefined;
    subborrowxU64(&x11, &x12, x10, x3, 0xffffffff);
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    subborrowxU64(&x13, &x14, x12, x5, @as(u64, 0x0));
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    subborrowxU64(&x15, &x16, x14, x7, 0xffffffff00000001);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    subborrowxU64(&x17, &x18, x16, @as(u64, x8), @as(u64, 0x0));
    var x19: u64 = undefined;
    cmovznzU64(&x19, x18, x9, x1);
    var x20: u64 = undefined;
    cmovznzU64(&x20, x18, x11, x3);
    var x21: u64 = undefined;
    cmovznzU64(&x21, x18, x13, x5);
    var x22: u64 = undefined;
    cmovznzU64(&x22, x18, x15, x7);
    out1[0] = x19;
    out1[1] = x20;
    out1[2] = x21;
    out1[3] = x22;
}

/// The function sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
pub fn sub(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement, arg2: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    subborrowxU64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    var x3: u64 = undefined;
    var x4: u1 = undefined;
    subborrowxU64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    var x5: u64 = undefined;
    var x6: u1 = undefined;
    subborrowxU64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    var x7: u64 = undefined;
    var x8: u1 = undefined;
    subborrowxU64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    var x9: u64 = undefined;
    cmovznzU64(&x9, x8, @as(u64, 0x0), 0xffffffffffffffff);
    var x10: u64 = undefined;
    var x11: u1 = undefined;
    addcarryxU64(&x10, &x11, 0x0, x1, x9);
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, x11, x3, (x9 & 0xffffffff));
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, x5, @as(u64, 0x0));
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, x7, (x9 & 0xffffffff00000001));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/// The function opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
pub fn opp(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    subborrowxU64(&x1, &x2, 0x0, @as(u64, 0x0), (arg1[0]));
    var x3: u64 = undefined;
    var x4: u1 = undefined;
    subborrowxU64(&x3, &x4, x2, @as(u64, 0x0), (arg1[1]));
    var x5: u64 = undefined;
    var x6: u1 = undefined;
    subborrowxU64(&x5, &x6, x4, @as(u64, 0x0), (arg1[2]));
    var x7: u64 = undefined;
    var x8: u1 = undefined;
    subborrowxU64(&x7, &x8, x6, @as(u64, 0x0), (arg1[3]));
    var x9: u64 = undefined;
    cmovznzU64(&x9, x8, @as(u64, 0x0), 0xffffffffffffffff);
    var x10: u64 = undefined;
    var x11: u1 = undefined;
    addcarryxU64(&x10, &x11, 0x0, x1, x9);
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, x11, x3, (x9 & 0xffffffff));
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, x5, @as(u64, 0x0));
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, x7, (x9 & 0xffffffff00000001));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/// The function fromMontgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
///   0 ≤ eval out1 < m
///
pub fn fromMontgomery(out1: *NonMontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[0]);
    var x2: u64 = undefined;
    var x3: u64 = undefined;
    mulxU64(&x2, &x3, x1, 0xffffffff00000001);
    var x4: u64 = undefined;
    var x5: u64 = undefined;
    mulxU64(&x4, &x5, x1, 0xffffffff);
    var x6: u64 = undefined;
    var x7: u64 = undefined;
    mulxU64(&x6, &x7, x1, 0xffffffffffffffff);
    var x8: u64 = undefined;
    var x9: u1 = undefined;
    addcarryxU64(&x8, &x9, 0x0, x7, x4);
    var x10: u64 = undefined;
    var x11: u1 = undefined;
    addcarryxU64(&x10, &x11, 0x0, x1, x6);
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, x11, @as(u64, 0x0), x8);
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, 0x0, x12, (arg1[1]));
    var x16: u64 = undefined;
    var x17: u64 = undefined;
    mulxU64(&x16, &x17, x14, 0xffffffff00000001);
    var x18: u64 = undefined;
    var x19: u64 = undefined;
    mulxU64(&x18, &x19, x14, 0xffffffff);
    var x20: u64 = undefined;
    var x21: u64 = undefined;
    mulxU64(&x20, &x21, x14, 0xffffffffffffffff);
    var x22: u64 = undefined;
    var x23: u1 = undefined;
    addcarryxU64(&x22, &x23, 0x0, x21, x18);
    var x24: u64 = undefined;
    var x25: u1 = undefined;
    addcarryxU64(&x24, &x25, 0x0, x14, x20);
    var x26: u64 = undefined;
    var x27: u1 = undefined;
    addcarryxU64(&x26, &x27, x25, (@as(u64, x15) + (@as(u64, x13) + (@as(u64, x9) + x5))), x22);
    var x28: u64 = undefined;
    var x29: u1 = undefined;
    addcarryxU64(&x28, &x29, x27, x2, (@as(u64, x23) + x19));
    var x30: u64 = undefined;
    var x31: u1 = undefined;
    addcarryxU64(&x30, &x31, x29, x3, x16);
    var x32: u64 = undefined;
    var x33: u1 = undefined;
    addcarryxU64(&x32, &x33, 0x0, x26, (arg1[2]));
    var x34: u64 = undefined;
    var x35: u1 = undefined;
    addcarryxU64(&x34, &x35, x33, x28, @as(u64, 0x0));
    var x36: u64 = undefined;
    var x37: u1 = undefined;
    addcarryxU64(&x36, &x37, x35, x30, @as(u64, 0x0));
    var x38: u64 = undefined;
    var x39: u64 = undefined;
    mulxU64(&x38, &x39, x32, 0xffffffff00000001);
    var x40: u64 = undefined;
    var x41: u64 = undefined;
    mulxU64(&x40, &x41, x32, 0xffffffff);
    var x42: u64 = undefined;
    var x43: u64 = undefined;
    mulxU64(&x42, &x43, x32, 0xffffffffffffffff);
    var x44: u64 = undefined;
    var x45: u1 = undefined;
    addcarryxU64(&x44, &x45, 0x0, x43, x40);
    var x46: u64 = undefined;
    var x47: u1 = undefined;
    addcarryxU64(&x46, &x47, 0x0, x32, x42);
    var x48: u64 = undefined;
    var x49: u1 = undefined;
    addcarryxU64(&x48, &x49, x47, x34, x44);
    var x50: u64 = undefined;
    var x51: u1 = undefined;
    addcarryxU64(&x50, &x51, x49, x36, (@as(u64, x45) + x41));
    var x52: u64 = undefined;
    var x53: u1 = undefined;
    addcarryxU64(&x52, &x53, x51, (@as(u64, x37) + (@as(u64, x31) + x17)), x38);
    var x54: u64 = undefined;
    var x55: u1 = undefined;
    addcarryxU64(&x54, &x55, 0x0, x48, (arg1[3]));
    var x56: u64 = undefined;
    var x57: u1 = undefined;
    addcarryxU64(&x56, &x57, x55, x50, @as(u64, 0x0));
    var x58: u64 = undefined;
    var x59: u1 = undefined;
    addcarryxU64(&x58, &x59, x57, x52, @as(u64, 0x0));
    var x60: u64 = undefined;
    var x61: u64 = undefined;
    mulxU64(&x60, &x61, x54, 0xffffffff00000001);
    var x62: u64 = undefined;
    var x63: u64 = undefined;
    mulxU64(&x62, &x63, x54, 0xffffffff);
    var x64: u64 = undefined;
    var x65: u64 = undefined;
    mulxU64(&x64, &x65, x54, 0xffffffffffffffff);
    var x66: u64 = undefined;
    var x67: u1 = undefined;
    addcarryxU64(&x66, &x67, 0x0, x65, x62);
    var x68: u64 = undefined;
    var x69: u1 = undefined;
    addcarryxU64(&x68, &x69, 0x0, x54, x64);
    var x70: u64 = undefined;
    var x71: u1 = undefined;
    addcarryxU64(&x70, &x71, x69, x56, x66);
    var x72: u64 = undefined;
    var x73: u1 = undefined;
    addcarryxU64(&x72, &x73, x71, x58, (@as(u64, x67) + x63));
    var x74: u64 = undefined;
    var x75: u1 = undefined;
    addcarryxU64(&x74, &x75, x73, (@as(u64, x59) + (@as(u64, x53) + x39)), x60);
    const x76 = (@as(u64, x75) + x61);
    var x77: u64 = undefined;
    var x78: u1 = undefined;
    subborrowxU64(&x77, &x78, 0x0, x70, 0xffffffffffffffff);
    var x79: u64 = undefined;
    var x80: u1 = undefined;
    subborrowxU64(&x79, &x80, x78, x72, 0xffffffff);
    var x81: u64 = undefined;
    var x82: u1 = undefined;
    subborrowxU64(&x81, &x82, x80, x74, @as(u64, 0x0));
    var x83: u64 = undefined;
    var x84: u1 = undefined;
    subborrowxU64(&x83, &x84, x82, x76, 0xffffffff00000001);
    var x85: u64 = undefined;
    var x86: u1 = undefined;
    subborrowxU64(&x85, &x86, x84, @as(u64, 0x0), @as(u64, 0x0));
    var x87: u64 = undefined;
    cmovznzU64(&x87, x86, x77, x70);
    var x88: u64 = undefined;
    cmovznzU64(&x88, x86, x79, x72);
    var x89: u64 = undefined;
    cmovznzU64(&x89, x86, x81, x74);
    var x90: u64 = undefined;
    cmovznzU64(&x90, x86, x83, x76);
    out1[0] = x87;
    out1[1] = x88;
    out1[2] = x89;
    out1[3] = x90;
}

/// The function toMontgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
pub fn toMontgomery(out1: *MontgomeryDomainFieldElement, arg1: NonMontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[1]);
    const x2 = (arg1[2]);
    const x3 = (arg1[3]);
    const x4 = (arg1[0]);
    var x5: u64 = undefined;
    var x6: u64 = undefined;
    mulxU64(&x5, &x6, x4, 0x4fffffffd);
    var x7: u64 = undefined;
    var x8: u64 = undefined;
    mulxU64(&x7, &x8, x4, 0xfffffffffffffffe);
    var x9: u64 = undefined;
    var x10: u64 = undefined;
    mulxU64(&x9, &x10, x4, 0xfffffffbffffffff);
    var x11: u64 = undefined;
    var x12: u64 = undefined;
    mulxU64(&x11, &x12, x4, 0x3);
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    addcarryxU64(&x13, &x14, 0x0, x12, x9);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    addcarryxU64(&x15, &x16, x14, x10, x7);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    addcarryxU64(&x17, &x18, x16, x8, x5);
    var x19: u64 = undefined;
    var x20: u64 = undefined;
    mulxU64(&x19, &x20, x11, 0xffffffff00000001);
    var x21: u64 = undefined;
    var x22: u64 = undefined;
    mulxU64(&x21, &x22, x11, 0xffffffff);
    var x23: u64 = undefined;
    var x24: u64 = undefined;
    mulxU64(&x23, &x24, x11, 0xffffffffffffffff);
    var x25: u64 = undefined;
    var x26: u1 = undefined;
    addcarryxU64(&x25, &x26, 0x0, x24, x21);
    var x27: u64 = undefined;
    var x28: u1 = undefined;
    addcarryxU64(&x27, &x28, 0x0, x11, x23);
    var x29: u64 = undefined;
    var x30: u1 = undefined;
    addcarryxU64(&x29, &x30, x28, x13, x25);
    var x31: u64 = undefined;
    var x32: u1 = undefined;
    addcarryxU64(&x31, &x32, x30, x15, (@as(u64, x26) + x22));
    var x33: u64 = undefined;
    var x34: u1 = undefined;
    addcarryxU64(&x33, &x34, x32, x17, x19);
    var x35: u64 = undefined;
    var x36: u1 = undefined;
    addcarryxU64(&x35, &x36, x34, (@as(u64, x18) + x6), x20);
    var x37: u64 = undefined;
    var x38: u64 = undefined;
    mulxU64(&x37, &x38, x1, 0x4fffffffd);
    var x39: u64 = undefined;
    var x40: u64 = undefined;
    mulxU64(&x39, &x40, x1, 0xfffffffffffffffe);
    var x41: u64 = undefined;
    var x42: u64 = undefined;
    mulxU64(&x41, &x42, x1, 0xfffffffbffffffff);
    var x43: u64 = undefined;
    var x44: u64 = undefined;
    mulxU64(&x43, &x44, x1, 0x3);
    var x45: u64 = undefined;
    var x46: u1 = undefined;
    addcarryxU64(&x45, &x46, 0x0, x44, x41);
    var x47: u64 = undefined;
    var x48: u1 = undefined;
    addcarryxU64(&x47, &x48, x46, x42, x39);
    var x49: u64 = undefined;
    var x50: u1 = undefined;
    addcarryxU64(&x49, &x50, x48, x40, x37);
    var x51: u64 = undefined;
    var x52: u1 = undefined;
    addcarryxU64(&x51, &x52, 0x0, x29, x43);
    var x53: u64 = undefined;
    var x54: u1 = undefined;
    addcarryxU64(&x53, &x54, x52, x31, x45);
    var x55: u64 = undefined;
    var x56: u1 = undefined;
    addcarryxU64(&x55, &x56, x54, x33, x47);
    var x57: u64 = undefined;
    var x58: u1 = undefined;
    addcarryxU64(&x57, &x58, x56, x35, x49);
    var x59: u64 = undefined;
    var x60: u64 = undefined;
    mulxU64(&x59, &x60, x51, 0xffffffff00000001);
    var x61: u64 = undefined;
    var x62: u64 = undefined;
    mulxU64(&x61, &x62, x51, 0xffffffff);
    var x63: u64 = undefined;
    var x64: u64 = undefined;
    mulxU64(&x63, &x64, x51, 0xffffffffffffffff);
    var x65: u64 = undefined;
    var x66: u1 = undefined;
    addcarryxU64(&x65, &x66, 0x0, x64, x61);
    var x67: u64 = undefined;
    var x68: u1 = undefined;
    addcarryxU64(&x67, &x68, 0x0, x51, x63);
    var x69: u64 = undefined;
    var x70: u1 = undefined;
    addcarryxU64(&x69, &x70, x68, x53, x65);
    var x71: u64 = undefined;
    var x72: u1 = undefined;
    addcarryxU64(&x71, &x72, x70, x55, (@as(u64, x66) + x62));
    var x73: u64 = undefined;
    var x74: u1 = undefined;
    addcarryxU64(&x73, &x74, x72, x57, x59);
    var x75: u64 = undefined;
    var x76: u1 = undefined;
    addcarryxU64(&x75, &x76, x74, ((@as(u64, x58) + @as(u64, x36)) + (@as(u64, x50) + x38)), x60);
    var x77: u64 = undefined;
    var x78: u64 = undefined;
    mulxU64(&x77, &x78, x2, 0x4fffffffd);
    var x79: u64 = undefined;
    var x80: u64 = undefined;
    mulxU64(&x79, &x80, x2, 0xfffffffffffffffe);
    var x81: u64 = undefined;
    var x82: u64 = undefined;
    mulxU64(&x81, &x82, x2, 0xfffffffbffffffff);
    var x83: u64 = undefined;
    var x84: u64 = undefined;
    mulxU64(&x83, &x84, x2, 0x3);
    var x85: u64 = undefined;
    var x86: u1 = undefined;
    addcarryxU64(&x85, &x86, 0x0, x84, x81);
    var x87: u64 = undefined;
    var x88: u1 = undefined;
    addcarryxU64(&x87, &x88, x86, x82, x79);
    var x89: u64 = undefined;
    var x90: u1 = undefined;
    addcarryxU64(&x89, &x90, x88, x80, x77);
    var x91: u64 = undefined;
    var x92: u1 = undefined;
    addcarryxU64(&x91, &x92, 0x0, x69, x83);
    var x93: u64 = undefined;
    var x94: u1 = undefined;
    addcarryxU64(&x93, &x94, x92, x71, x85);
    var x95: u64 = undefined;
    var x96: u1 = undefined;
    addcarryxU64(&x95, &x96, x94, x73, x87);
    var x97: u64 = undefined;
    var x98: u1 = undefined;
    addcarryxU64(&x97, &x98, x96, x75, x89);
    var x99: u64 = undefined;
    var x100: u64 = undefined;
    mulxU64(&x99, &x100, x91, 0xffffffff00000001);
    var x101: u64 = undefined;
    var x102: u64 = undefined;
    mulxU64(&x101, &x102, x91, 0xffffffff);
    var x103: u64 = undefined;
    var x104: u64 = undefined;
    mulxU64(&x103, &x104, x91, 0xffffffffffffffff);
    var x105: u64 = undefined;
    var x106: u1 = undefined;
    addcarryxU64(&x105, &x106, 0x0, x104, x101);
    var x107: u64 = undefined;
    var x108: u1 = undefined;
    addcarryxU64(&x107, &x108, 0x0, x91, x103);
    var x109: u64 = undefined;
    var x110: u1 = undefined;
    addcarryxU64(&x109, &x110, x108, x93, x105);
    var x111: u64 = undefined;
    var x112: u1 = undefined;
    addcarryxU64(&x111, &x112, x110, x95, (@as(u64, x106) + x102));
    var x113: u64 = undefined;
    var x114: u1 = undefined;
    addcarryxU64(&x113, &x114, x112, x97, x99);
    var x115: u64 = undefined;
    var x116: u1 = undefined;
    addcarryxU64(&x115, &x116, x114, ((@as(u64, x98) + @as(u64, x76)) + (@as(u64, x90) + x78)), x100);
    var x117: u64 = undefined;
    var x118: u64 = undefined;
    mulxU64(&x117, &x118, x3, 0x4fffffffd);
    var x119: u64 = undefined;
    var x120: u64 = undefined;
    mulxU64(&x119, &x120, x3, 0xfffffffffffffffe);
    var x121: u64 = undefined;
    var x122: u64 = undefined;
    mulxU64(&x121, &x122, x3, 0xfffffffbffffffff);
    var x123: u64 = undefined;
    var x124: u64 = undefined;
    mulxU64(&x123, &x124, x3, 0x3);
    var x125: u64 = undefined;
    var x126: u1 = undefined;
    addcarryxU64(&x125, &x126, 0x0, x124, x121);
    var x127: u64 = undefined;
    var x128: u1 = undefined;
    addcarryxU64(&x127, &x128, x126, x122, x119);
    var x129: u64 = undefined;
    var x130: u1 = undefined;
    addcarryxU64(&x129, &x130, x128, x120, x117);
    var x131: u64 = undefined;
    var x132: u1 = undefined;
    addcarryxU64(&x131, &x132, 0x0, x109, x123);
    var x133: u64 = undefined;
    var x134: u1 = undefined;
    addcarryxU64(&x133, &x134, x132, x111, x125);
    var x135: u64 = undefined;
    var x136: u1 = undefined;
    addcarryxU64(&x135, &x136, x134, x113, x127);
    var x137: u64 = undefined;
    var x138: u1 = undefined;
    addcarryxU64(&x137, &x138, x136, x115, x129);
    var x139: u64 = undefined;
    var x140: u64 = undefined;
    mulxU64(&x139, &x140, x131, 0xffffffff00000001);
    var x141: u64 = undefined;
    var x142: u64 = undefined;
    mulxU64(&x141, &x142, x131, 0xffffffff);
    var x143: u64 = undefined;
    var x144: u64 = undefined;
    mulxU64(&x143, &x144, x131, 0xffffffffffffffff);
    var x145: u64 = undefined;
    var x146: u1 = undefined;
    addcarryxU64(&x145, &x146, 0x0, x144, x141);
    var x147: u64 = undefined;
    var x148: u1 = undefined;
    addcarryxU64(&x147, &x148, 0x0, x131, x143);
    var x149: u64 = undefined;
    var x150: u1 = undefined;
    addcarryxU64(&x149, &x150, x148, x133, x145);
    var x151: u64 = undefined;
    var x152: u1 = undefined;
    addcarryxU64(&x151, &x152, x150, x135, (@as(u64, x146) + x142));
    var x153: u64 = undefined;
    var x154: u1 = undefined;
    addcarryxU64(&x153, &x154, x152, x137, x139);
    var x155: u64 = undefined;
    var x156: u1 = undefined;
    addcarryxU64(&x155, &x156, x154, ((@as(u64, x138) + @as(u64, x116)) + (@as(u64, x130) + x118)), x140);
    var x157: u64 = undefined;
    var x158: u1 = undefined;
    subborrowxU64(&x157, &x158, 0x0, x149, 0xffffffffffffffff);
    var x159: u64 = undefined;
    var x160: u1 = undefined;
    subborrowxU64(&x159, &x160, x158, x151, 0xffffffff);
    var x161: u64 = undefined;
    var x162: u1 = undefined;
    subborrowxU64(&x161, &x162, x160, x153, @as(u64, 0x0));
    var x163: u64 = undefined;
    var x164: u1 = undefined;
    subborrowxU64(&x163, &x164, x162, x155, 0xffffffff00000001);
    var x165: u64 = undefined;
    var x166: u1 = undefined;
    subborrowxU64(&x165, &x166, x164, @as(u64, x156), @as(u64, 0x0));
    var x167: u64 = undefined;
    cmovznzU64(&x167, x166, x157, x149);
    var x168: u64 = undefined;
    cmovznzU64(&x168, x166, x159, x151);
    var x169: u64 = undefined;
    cmovznzU64(&x169, x166, x161, x153);
    var x170: u64 = undefined;
    cmovznzU64(&x170, x166, x163, x155);
    out1[0] = x167;
    out1[1] = x168;
    out1[2] = x169;
    out1[3] = x170;
}

/// The function nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
pub fn nonzero(out1: *u64, arg1: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
    out1.* = x1;
}

/// The function selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn selectznz(out1: *[4]u64, arg1: u1, arg2: [4]u64, arg3: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    cmovznzU64(&x1, arg1, (arg2[0]), (arg3[0]));
    var x2: u64 = undefined;
    cmovznzU64(&x2, arg1, (arg2[1]), (arg3[1]));
    var x3: u64 = undefined;
    cmovznzU64(&x3, arg1, (arg2[2]), (arg3[2]));
    var x4: u64 = undefined;
    cmovznzU64(&x4, arg1, (arg2[3]), (arg3[3]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
}

/// The function toBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
pub fn toBytes(out1: *[32]u8, arg1: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[3]);
    const x2 = (arg1[2]);
    const x3 = (arg1[1]);
    const x4 = (arg1[0]);
    const x5 = @truncate(u8, (x4 & @as(u64, 0xff)));
    const x6 = (x4 >> 8);
    const x7 = @truncate(u8, (x6 & @as(u64, 0xff)));
    const x8 = (x6 >> 8);
    const x9 = @truncate(u8, (x8 & @as(u64, 0xff)));
    const x10 = (x8 >> 8);
    const x11 = @truncate(u8, (x10 & @as(u64, 0xff)));
    const x12 = (x10 >> 8);
    const x13 = @truncate(u8, (x12 & @as(u64, 0xff)));
    const x14 = (x12 >> 8);
    const x15 = @truncate(u8, (x14 & @as(u64, 0xff)));
    const x16 = (x14 >> 8);
    const x17 = @truncate(u8, (x16 & @as(u64, 0xff)));
    const x18 = @truncate(u8, (x16 >> 8));
    const x19 = @truncate(u8, (x3 & @as(u64, 0xff)));
    const x20 = (x3 >> 8);
    const x21 = @truncate(u8, (x20 & @as(u64, 0xff)));
    const x22 = (x20 >> 8);
    const x23 = @truncate(u8, (x22 & @as(u64, 0xff)));
    const x24 = (x22 >> 8);
    const x25 = @truncate(u8, (x24 & @as(u64, 0xff)));
    const x26 = (x24 >> 8);
    const x27 = @truncate(u8, (x26 & @as(u64, 0xff)));
    const x28 = (x26 >> 8);
    const x29 = @truncate(u8, (x28 & @as(u64, 0xff)));
    const x30 = (x28 >> 8);
    const x31 = @truncate(u8, (x30 & @as(u64, 0xff)));
    const x32 = @truncate(u8, (x30 >> 8));
    const x33 = @truncate(u8, (x2 & @as(u64, 0xff)));
    const x34 = (x2 >> 8);
    const x35 = @truncate(u8, (x34 & @as(u64, 0xff)));
    const x36 = (x34 >> 8);
    const x37 = @truncate(u8, (x36 & @as(u64, 0xff)));
    const x38 = (x36 >> 8);
    const x39 = @truncate(u8, (x38 & @as(u64, 0xff)));
    const x40 = (x38 >> 8);
    const x41 = @truncate(u8, (x40 & @as(u64, 0xff)));
    const x42 = (x40 >> 8);
    const x43 = @truncate(u8, (x42 & @as(u64, 0xff)));
    const x44 = (x42 >> 8);
    const x45 = @truncate(u8, (x44 & @as(u64, 0xff)));
    const x46 = @truncate(u8, (x44 >> 8));
    const x47 = @truncate(u8, (x1 & @as(u64, 0xff)));
    const x48 = (x1 >> 8);
    const x49 = @truncate(u8, (x48 & @as(u64, 0xff)));
    const x50 = (x48 >> 8);
    const x51 = @truncate(u8, (x50 & @as(u64, 0xff)));
    const x52 = (x50 >> 8);
    const x53 = @truncate(u8, (x52 & @as(u64, 0xff)));
    const x54 = (x52 >> 8);
    const x55 = @truncate(u8, (x54 & @as(u64, 0xff)));
    const x56 = (x54 >> 8);
    const x57 = @truncate(u8, (x56 & @as(u64, 0xff)));
    const x58 = (x56 >> 8);
    const x59 = @truncate(u8, (x58 & @as(u64, 0xff)));
    const x60 = @truncate(u8, (x58 >> 8));
    out1[0] = x5;
    out1[1] = x7;
    out1[2] = x9;
    out1[3] = x11;
    out1[4] = x13;
    out1[5] = x15;
    out1[6] = x17;
    out1[7] = x18;
    out1[8] = x19;
    out1[9] = x21;
    out1[10] = x23;
    out1[11] = x25;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x39;
    out1[20] = x41;
    out1[21] = x43;
    out1[22] = x45;
    out1[23] = x46;
    out1[24] = x47;
    out1[25] = x49;
    out1[26] = x51;
    out1[27] = x53;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
}

/// The function fromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn fromBytes(out1: *[4]u64, arg1: [32]u8) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (@as(u64, (arg1[31])) << 56);
    const x2 = (@as(u64, (arg1[30])) << 48);
    const x3 = (@as(u64, (arg1[29])) << 40);
    const x4 = (@as(u64, (arg1[28])) << 32);
    const x5 = (@as(u64, (arg1[27])) << 24);
    const x6 = (@as(u64, (arg1[26])) << 16);
    const x7 = (@as(u64, (arg1[25])) << 8);
    const x8 = (arg1[24]);
    const x9 = (@as(u64, (arg1[23])) << 56);
    const x10 = (@as(u64, (arg1[22])) << 48);
    const x11 = (@as(u64, (arg1[21])) << 40);
    const x12 = (@as(u64, (arg1[20])) << 32);
    const x13 = (@as(u64, (arg1[19])) << 24);
    const x14 = (@as(u64, (arg1[18])) << 16);
    const x15 = (@as(u64, (arg1[17])) << 8);
    const x16 = (arg1[16]);
    const x17 = (@as(u64, (arg1[15])) << 56);
    const x18 = (@as(u64, (arg1[14])) << 48);
    const x19 = (@as(u64, (arg1[13])) << 40);
    const x20 = (@as(u64, (arg1[12])) << 32);
    const x21 = (@as(u64, (arg1[11])) << 24);
    const x22 = (@as(u64, (arg1[10])) << 16);
    const x23 = (@as(u64, (arg1[9])) << 8);
    const x24 = (arg1[8]);
    const x25 = (@as(u64, (arg1[7])) << 56);
    const x26 = (@as(u64, (arg1[6])) << 48);
    const x27 = (@as(u64, (arg1[5])) << 40);
    const x28 = (@as(u64, (arg1[4])) << 32);
    const x29 = (@as(u64, (arg1[3])) << 24);
    const x30 = (@as(u64, (arg1[2])) << 16);
    const x31 = (@as(u64, (arg1[1])) << 8);
    const x32 = (arg1[0]);
    const x33 = (x31 + @as(u64, x32));
    const x34 = (x30 + x33);
    const x35 = (x29 + x34);
    const x36 = (x28 + x35);
    const x37 = (x27 + x36);
    const x38 = (x26 + x37);
    const x39 = (x25 + x38);
    const x40 = (x23 + @as(u64, x24));
    const x41 = (x22 + x40);
    const x42 = (x21 + x41);
    const x43 = (x20 + x42);
    const x44 = (x19 + x43);
    const x45 = (x18 + x44);
    const x46 = (x17 + x45);
    const x47 = (x15 + @as(u64, x16));
    const x48 = (x14 + x47);
    const x49 = (x13 + x48);
    const x50 = (x12 + x49);
    const x51 = (x11 + x50);
    const x52 = (x10 + x51);
    const x53 = (x9 + x52);
    const x54 = (x7 + @as(u64, x8));
    const x55 = (x6 + x54);
    const x56 = (x5 + x55);
    const x57 = (x4 + x56);
    const x58 = (x3 + x57);
    const x59 = (x2 + x58);
    const x60 = (x1 + x59);
    out1[0] = x39;
    out1[1] = x46;
    out1[2] = x53;
    out1[3] = x60;
}

/// The function setOne returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
pub fn setOne(out1: *MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    out1[0] = @as(u64, 0x1);
    out1[1] = 0xffffffff00000000;
    out1[2] = 0xffffffffffffffff;
    out1[3] = 0xfffffffe;
}

/// The function msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn msat(out1: *[5]u64) void {
    @setRuntimeSafety(mode == .Debug);

    out1[0] = 0xffffffffffffffff;
    out1[1] = 0xffffffff;
    out1[2] = @as(u64, 0x0);
    out1[3] = 0xffffffff00000001;
    out1[4] = @as(u64, 0x0);
}

/// The function divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn divstep(out1: *u64, out2: *[5]u64, out3: *[5]u64, out4: *[4]u64, out5: *[4]u64, arg1: u64, arg2: [5]u64, arg3: [5]u64, arg4: [4]u64, arg5: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    addcarryxU64(&x1, &x2, 0x0, (~arg1), @as(u64, 0x1));
    const x3 = (@truncate(u1, (x1 >> 63)) & @truncate(u1, ((arg3[0]) & @as(u64, 0x1))));
    var x4: u64 = undefined;
    var x5: u1 = undefined;
    addcarryxU64(&x4, &x5, 0x0, (~arg1), @as(u64, 0x1));
    var x6: u64 = undefined;
    cmovznzU64(&x6, x3, arg1, x4);
    var x7: u64 = undefined;
    cmovznzU64(&x7, x3, (arg2[0]), (arg3[0]));
    var x8: u64 = undefined;
    cmovznzU64(&x8, x3, (arg2[1]), (arg3[1]));
    var x9: u64 = undefined;
    cmovznzU64(&x9, x3, (arg2[2]), (arg3[2]));
    var x10: u64 = undefined;
    cmovznzU64(&x10, x3, (arg2[3]), (arg3[3]));
    var x11: u64 = undefined;
    cmovznzU64(&x11, x3, (arg2[4]), (arg3[4]));
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, 0x0, @as(u64, 0x1), (~(arg2[0])));
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, @as(u64, 0x0), (~(arg2[1])));
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, @as(u64, 0x0), (~(arg2[2])));
    var x18: u64 = undefined;
    var x19: u1 = undefined;
    addcarryxU64(&x18, &x19, x17, @as(u64, 0x0), (~(arg2[3])));
    var x20: u64 = undefined;
    var x21: u1 = undefined;
    addcarryxU64(&x20, &x21, x19, @as(u64, 0x0), (~(arg2[4])));
    var x22: u64 = undefined;
    cmovznzU64(&x22, x3, (arg3[0]), x12);
    var x23: u64 = undefined;
    cmovznzU64(&x23, x3, (arg3[1]), x14);
    var x24: u64 = undefined;
    cmovznzU64(&x24, x3, (arg3[2]), x16);
    var x25: u64 = undefined;
    cmovznzU64(&x25, x3, (arg3[3]), x18);
    var x26: u64 = undefined;
    cmovznzU64(&x26, x3, (arg3[4]), x20);
    var x27: u64 = undefined;
    cmovznzU64(&x27, x3, (arg4[0]), (arg5[0]));
    var x28: u64 = undefined;
    cmovznzU64(&x28, x3, (arg4[1]), (arg5[1]));
    var x29: u64 = undefined;
    cmovznzU64(&x29, x3, (arg4[2]), (arg5[2]));
    var x30: u64 = undefined;
    cmovznzU64(&x30, x3, (arg4[3]), (arg5[3]));
    var x31: u64 = undefined;
    var x32: u1 = undefined;
    addcarryxU64(&x31, &x32, 0x0, x27, x27);
    var x33: u64 = undefined;
    var x34: u1 = undefined;
    addcarryxU64(&x33, &x34, x32, x28, x28);
    var x35: u64 = undefined;
    var x36: u1 = undefined;
    addcarryxU64(&x35, &x36, x34, x29, x29);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, x36, x30, x30);
    var x39: u64 = undefined;
    var x40: u1 = undefined;
    subborrowxU64(&x39, &x40, 0x0, x31, 0xffffffffffffffff);
    var x41: u64 = undefined;
    var x42: u1 = undefined;
    subborrowxU64(&x41, &x42, x40, x33, 0xffffffff);
    var x43: u64 = undefined;
    var x44: u1 = undefined;
    subborrowxU64(&x43, &x44, x42, x35, @as(u64, 0x0));
    var x45: u64 = undefined;
    var x46: u1 = undefined;
    subborrowxU64(&x45, &x46, x44, x37, 0xffffffff00000001);
    var x47: u64 = undefined;
    var x48: u1 = undefined;
    subborrowxU64(&x47, &x48, x46, @as(u64, x38), @as(u64, 0x0));
    const x49 = (arg4[3]);
    const x50 = (arg4[2]);
    const x51 = (arg4[1]);
    const x52 = (arg4[0]);
    var x53: u64 = undefined;
    var x54: u1 = undefined;
    subborrowxU64(&x53, &x54, 0x0, @as(u64, 0x0), x52);
    var x55: u64 = undefined;
    var x56: u1 = undefined;
    subborrowxU64(&x55, &x56, x54, @as(u64, 0x0), x51);
    var x57: u64 = undefined;
    var x58: u1 = undefined;
    subborrowxU64(&x57, &x58, x56, @as(u64, 0x0), x50);
    var x59: u64 = undefined;
    var x60: u1 = undefined;
    subborrowxU64(&x59, &x60, x58, @as(u64, 0x0), x49);
    var x61: u64 = undefined;
    cmovznzU64(&x61, x60, @as(u64, 0x0), 0xffffffffffffffff);
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, 0x0, x53, x61);
    var x64: u64 = undefined;
    var x65: u1 = undefined;
    addcarryxU64(&x64, &x65, x63, x55, (x61 & 0xffffffff));
    var x66: u64 = undefined;
    var x67: u1 = undefined;
    addcarryxU64(&x66, &x67, x65, x57, @as(u64, 0x0));
    var x68: u64 = undefined;
    var x69: u1 = undefined;
    addcarryxU64(&x68, &x69, x67, x59, (x61 & 0xffffffff00000001));
    var x70: u64 = undefined;
    cmovznzU64(&x70, x3, (arg5[0]), x62);
    var x71: u64 = undefined;
    cmovznzU64(&x71, x3, (arg5[1]), x64);
    var x72: u64 = undefined;
    cmovznzU64(&x72, x3, (arg5[2]), x66);
    var x73: u64 = undefined;
    cmovznzU64(&x73, x3, (arg5[3]), x68);
    const x74 = @truncate(u1, (x22 & @as(u64, 0x1)));
    var x75: u64 = undefined;
    cmovznzU64(&x75, x74, @as(u64, 0x0), x7);
    var x76: u64 = undefined;
    cmovznzU64(&x76, x74, @as(u64, 0x0), x8);
    var x77: u64 = undefined;
    cmovznzU64(&x77, x74, @as(u64, 0x0), x9);
    var x78: u64 = undefined;
    cmovznzU64(&x78, x74, @as(u64, 0x0), x10);
    var x79: u64 = undefined;
    cmovznzU64(&x79, x74, @as(u64, 0x0), x11);
    var x80: u64 = undefined;
    var x81: u1 = undefined;
    addcarryxU64(&x80, &x81, 0x0, x22, x75);
    var x82: u64 = undefined;
    var x83: u1 = undefined;
    addcarryxU64(&x82, &x83, x81, x23, x76);
    var x84: u64 = undefined;
    var x85: u1 = undefined;
    addcarryxU64(&x84, &x85, x83, x24, x77);
    var x86: u64 = undefined;
    var x87: u1 = undefined;
    addcarryxU64(&x86, &x87, x85, x25, x78);
    var x88: u64 = undefined;
    var x89: u1 = undefined;
    addcarryxU64(&x88, &x89, x87, x26, x79);
    var x90: u64 = undefined;
    cmovznzU64(&x90, x74, @as(u64, 0x0), x27);
    var x91: u64 = undefined;
    cmovznzU64(&x91, x74, @as(u64, 0x0), x28);
    var x92: u64 = undefined;
    cmovznzU64(&x92, x74, @as(u64, 0x0), x29);
    var x93: u64 = undefined;
    cmovznzU64(&x93, x74, @as(u64, 0x0), x30);
    var x94: u64 = undefined;
    var x95: u1 = undefined;
    addcarryxU64(&x94, &x95, 0x0, x70, x90);
    var x96: u64 = undefined;
    var x97: u1 = undefined;
    addcarryxU64(&x96, &x97, x95, x71, x91);
    var x98: u64 = undefined;
    var x99: u1 = undefined;
    addcarryxU64(&x98, &x99, x97, x72, x92);
    var x100: u64 = undefined;
    var x101: u1 = undefined;
    addcarryxU64(&x100, &x101, x99, x73, x93);
    var x102: u64 = undefined;
    var x103: u1 = undefined;
    subborrowxU64(&x102, &x103, 0x0, x94, 0xffffffffffffffff);
    var x104: u64 = undefined;
    var x105: u1 = undefined;
    subborrowxU64(&x104, &x105, x103, x96, 0xffffffff);
    var x106: u64 = undefined;
    var x107: u1 = undefined;
    subborrowxU64(&x106, &x107, x105, x98, @as(u64, 0x0));
    var x108: u64 = undefined;
    var x109: u1 = undefined;
    subborrowxU64(&x108, &x109, x107, x100, 0xffffffff00000001);
    var x110: u64 = undefined;
    var x111: u1 = undefined;
    subborrowxU64(&x110, &x111, x109, @as(u64, x101), @as(u64, 0x0));
    var x112: u64 = undefined;
    var x113: u1 = undefined;
    addcarryxU64(&x112, &x113, 0x0, x6, @as(u64, 0x1));
    const x114 = ((x80 >> 1) | ((x82 << 63) & 0xffffffffffffffff));
    const x115 = ((x82 >> 1) | ((x84 << 63) & 0xffffffffffffffff));
    const x116 = ((x84 >> 1) | ((x86 << 63) & 0xffffffffffffffff));
    const x117 = ((x86 >> 1) | ((x88 << 63) & 0xffffffffffffffff));
    const x118 = ((x88 & 0x8000000000000000) | (x88 >> 1));
    var x119: u64 = undefined;
    cmovznzU64(&x119, x48, x39, x31);
    var x120: u64 = undefined;
    cmovznzU64(&x120, x48, x41, x33);
    var x121: u64 = undefined;
    cmovznzU64(&x121, x48, x43, x35);
    var x122: u64 = undefined;
    cmovznzU64(&x122, x48, x45, x37);
    var x123: u64 = undefined;
    cmovznzU64(&x123, x111, x102, x94);
    var x124: u64 = undefined;
    cmovznzU64(&x124, x111, x104, x96);
    var x125: u64 = undefined;
    cmovznzU64(&x125, x111, x106, x98);
    var x126: u64 = undefined;
    cmovznzU64(&x126, x111, x108, x100);
    out1.* = x112;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out3[0] = x114;
    out3[1] = x115;
    out3[2] = x116;
    out3[3] = x117;
    out3[4] = x118;
    out4[0] = x119;
    out4[1] = x120;
    out4[2] = x121;
    out4[3] = x122;
    out5[0] = x123;
    out5[1] = x124;
    out5[2] = x125;
    out5[3] = x126;
}

/// The function divstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn divstepPrecomp(out1: *[4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    out1[0] = 0x67ffffffb8000000;
    out1[1] = 0xc000000038000000;
    out1[2] = 0xd80000007fffffff;
    out1[3] = 0x2fffffffffffffff;
}
